#!/usr/bin/python
# Copyright (c) 2014 Adafruit Industries
# Author: Tony DiCola
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.

# Can enable debug output by uncommenting:
#import logging
#logging.basicConfig(level=logging.DEBUG)

import time
from datetime import datetime
import paho.mqtt.client as mqtt
import json

import Adafruit_MCP9808.MCP9808 as MCP9808

# MQTT Setup
mqttc=mqtt.Client()
mqttc.connect("<IP or DNS-Name>",keepalive=60)
mqttc.loop_start()
lastMsg = 0

#Json
data = {}

# Define a function to convert celsius to fahrenheit.
def c_to_f(c):
        return c * 9.0 / 5.0 + 32.0

# Default constructor will use the default I2C address (0x18) and pick a default I2C bus.
#
# For the Raspberry Pi this means you should hook up to the only exposed I2C bus
# from the main GPIO header and the library will figure out the bus number based
# on the Pi's revision.
#
# For the Beaglebone Black the library will assume bus 1 by default, which is
# exposed with SCL = P9_19 and SDA = P9_20.
sensor = MCP9808.MCP9808()

# Optionally you can override the address and/or bus number:
#sensor = MCP9808.MCP9808(address=0x20, busnum=2)

# Initialize communication with the sensor.
sensor.begin()

# Sensor auslesen
temp = sensor.readTempC()

# MQTT
#while True:
dt = datetime.now()
now_seconds = time.mktime(dt.timetuple()) + dt.microsecond/1e6
lastMsg = now_seconds
(result,mid) = mqttc.publish("weather/sensor/mcp9808/temperature", payload=temp, qos=0, retain=False)



# Save in Json-File
data['MCP9808'] = []
data['MCP9808'].append({
     'Temperature': temp
})
with open('/home/pi/weather-mcp9808.json', 'w') as json_file:
  json.dump(data, json_file)

json_file.close()
mqttc.disconnect()
mqttc.loop_stop()

