import time
import veml6070
import bisect
import json
from datetime import datetime
import paho.mqtt.client as mqtt

# MQTT Setup
mqttc=mqtt.Client()
mqttc.connect("<IP or DNS-Name>",keepalive=60)
mqttc.loop_start()
lastMsg = 0

#Json
data = {}



def getUvaIndex(uv_raw):
	#scaling value by integration times
	uvIndex = bisect.bisect_left([187,374,560,747,934,1120,1307,1494,1681,1868,2054], uv_raw)
	return uvIndex

if __name__ == '__main__':
	veml = veml6070.Veml6070()
	for i in [veml6070.INTEGRATIONTIME_1_2T,
		veml6070.INTEGRATIONTIME_1T,
		veml6070.INTEGRATIONTIME_2T,
		veml6070.INTEGRATIONTIME_4T]:
		veml.set_integration_time(i)
		#    uv_raw = 400
		uv_raw = veml.get_uva_light_intensity_raw()
		uva = veml.get_uva_light_intensity()
		UVa_index = format(getUvaIndex(uv_raw))

        # MQTT
        dt = datetime.now()
        now_seconds = time.mktime(dt.timetuple()) + dt.microsecond/1e6
        lastMsg = now_seconds
        (result,mid) = mqttc.publish("weather/sensor/veml6070/uv_raw", payload=uv_raw, qos=2, retain=True)
        (result,mid) = mqttc.publish("weather/sensor/veml6070/uva", payload=uva, qos=2, retain=True)
        (result,mid) = mqttc.publish("weather/sensor/veml6070/uva_index", payload=UVa_index, qos=2, retain=True)

        # Save in Json-File
        data['VEML6070'] = []
        data['VEML6070'].append({
             'UV-Raw': uv_raw,
             'UV-A': uva,
             'UV-A-Index': UVa_index
        })

        with open('/home/pi/weather-veml6070.json', 'w') as json_file:
             json.dump(data, json_file)

        
        json_file.close()
        mqttc.disconnect()
        mqttc.loop_stop()

