#!/usr/bin/python
#---------------------------------------------------------------------
#    ___  __
#   / _ \/ /
#  / , _/ /_
# /_/|_/____/ .
#               
#
#           wind_rain.py
# Read data from Arduino Pro Mini RainTotal, Windspeed, Winddirection
#                                 isRain and Wind-Gust
# Send date per MQTT
# weather/sensor/am328p/totalRainReset must publish with QoS=1 and
#   Retained=true
#
# Author : Ralph Lautenschlaeger
# Date   : 13/10/2019
#
#---------------------------------------------------------------------

import time
import string
import serial
import json
import paho.mqtt.client as mqtt
from struct import unpack
from binascii import unhexlify
from datetime import datetime

DEBUG = False

#Debug Print
def log(s):
    if DEBUG:
        print s


#MQTT  Setup
def on_connect(client, userdata, flags, rc):
   log("MQTT connecting...")
   # Fehler loggen
   if rc == 0:
      log("connected OK")
      mqttc.subscribe("weather/sensor/am328p/totalRainReset", qos=1)
   else:
      log("Connected With Result Code " (rc))

def on_message_for_is_rain_reset(client, userdata, message):
    log("Message Recieved for RainTotal: " + message.payload.decode())
#   Reset RainTotal wenn Topic totalRainReset=1
    if message.payload.decode() > "0":
       log("Reset RainTotal")
       ser.write("0")
#      Topic nach Reset wieder auf 0 setzen
       mqttc.unsubscribe("weather/sensor/am328p/totalRainReset") # sonst gibts eine Schleife
       (result,mid) = mqttc.publish("weather/sensor/am328p/totalRainReset", payload="0", qos=2, retain=True)

def on_message(client, userdata, message):
   log("Message Recieved from Others: "+message.payload.decode())

def on_subscribe(client, userdata, mid, granted_qos ):
   log("MQTT subscribe with ID: " + str(mid))
   log("Subscribing With Userdata: " + str(userdata))

def on_log(client, userdata, level, buf):
   log("log: "+buf)


log("Start....")
log("Init MQTT")
mqttc=mqtt.Client("Weatherstation")
mqttc.on_connect = on_connect
mqttc.on_message = on_message
mqttc.on_subscribe = on_subscribe
mqttc.on_log = on_log
mqttc.connect("<IP or DNS-Name>",keepalive=60)
# mqttc.subscribe("weather/sensor/am328p/totalRainReset", qos=1)
# RainTotalReset Topic Subscriben
mqttc.message_callback_add("weather/sensor/am328p/totalRainReset", on_message_for_is_rain_reset)
mqttc.loop_start()

lastMsg = 0

#Json
data = {}

currentWindGust=None;
currentWindSpeed=None;
currentWindDirection=None;
totalRain=None;
isRain=None;


# Decode an hex representation of a float to a float
#
# See:
# http://stackoverflow.com/questions/1592158/python-convert-hex-to-float/1...
# http://stackoverflow.com/questions/4315190/single-precision-big-endian-f...
def decode_float(s):
  """Other possible implementation. Don't know what's better
  # from ctypes import *
  s = s[6:8] + s[4:6] + s[2:4] + s[0:2] # reverse the byte order
  i = int(s, 16)                        # convert from hex to a Python int
  cp = pointer(c_int(i))                # make this into a c integer
  fp = cast(cp, POINTER(c_float))       # cast the int pointer to a float pointer
  return fp.contents.value              # dereference the pointer, get the float
  """
  return unpack('<f', unhexlify(s))[0]


def num(s):
    try:
        return int(s)
    except ValueError:
        return float(s)


log("open /dev/ttyS0") 
# configure the serial connections (the parameters differs on the device you are connecting to)
ser = serial.Serial(
	port='/dev/ttyS0',
	baudrate=9600,
	parity=serial.PARITY_NONE,
	stopbits=serial.STOPBITS_ONE,
	bytesize=serial.EIGHTBITS
)

if ser.isOpen():
   log("Ser.Port already open -> Close")
   ser.close()
log(ser.open())
log(ser.isOpen())

time.sleep(1)
ser.flushInput(); # clean input buffer

try:
   log("ser.write('1')")
   ser.write("1")
   time.sleep(1)
   value = ser.readline()
   log(value[0:10])
   if string.find(value, "f:") > -1:
       currentWindGust = decode_float(value[2:10])
       log(currentWindGust)
       log("")

   log("ser.write('2')")
   ser.write("2")
   time.sleep(1)
   value = ser.readline()
   log(value[0:10])
   if string.find(value, "f:") > -1:
       currentWindSpeed = decode_float(value[2:10])
       log(currentWindSpeed)
       log("")


   log("ser.write('3')")
   ser.write("3")
   time.sleep(1)
   value = ser.readline()
   log(value[0:10])
   if string.find(value, "f:") > -1:
       currentWindDirection = decode_float(value[2:10])
       log(currentWindDirection)
       log("")

   log("ser.write('4')")
   ser.write("4")
   time.sleep(1)
   value = ser.readline()
   log(value[0:10])
   if string.find(value, "f:") > -1:
       totalRain = decode_float(value[2:10]) * float("25.4") #* 25.4 - Korrektur wegen Fehler in AM328P
       log("totalRain: ")
       log(totalRain)
       log("")

   log("ser.write('5')")
   ser.write("5")
   time.sleep(1)
   value = ser.readline()
   log(value[0:10])
   if string.find(value, "f:") > -1:
       isRain = decode_float(value[2:10])
       log(isRain)
       log("")


   dt = datetime.now()
   now_seconds = time.mktime(dt.timetuple()) + dt.microsecond/1e6

   mqttc.loop(.1) # MQTT-Recieve-Buffer abfragen

#   if (now_seconds - lastMsg > 60 * 1): # MQTT messages every 5 minutes...
#   Vor Senden testen, ob in Variablen plausibele Werte stehen
   lastMsg = now_seconds
   if currentWindGust is not None:
        (result,mid) = mqttc.publish("weather/sensor/am328p/currentWindGust", payload=currentWindGust, qos=2, retain=True)
   if currentWindDirection is not None:
        (result,mid) = mqttc.publish("weather/sensor/am328p/currentWindDirection", payload=currentWindDirection, qos=2, retain=True)
   if currentWindSpeed is not None:
        (result,mid) = mqttc.publish("weather/sensor/am328p/currentWindSpeed", payload=currentWindSpeed, qos=2, retain=True)
   if totalRain is not None:
        (result,mid) = mqttc.publish("weather/sensor/am328p/totalRain", payload=totalRain, qos=2, retain=True)
   if isRain is not None:
        (result,mid) = mqttc.publish("weather/sensor/am328p/isRain", payload=isRain, qos=2, retain=True)


     # Save in Json-File
   data['AM328P'] = []
   data['AM328P'].append({
        'CurrentWindGust': currentWindGust,
        'CurrentWindDirection': currentWindDirection,
        'CurrentWindSpeed': currentWindSpeed,
        'TotalRain': totalRain,
        'IsRain': isRain
   })
   with open('/home/pi/weather-am328p.json', 'w') as json_file:
         json.dump(data, json_file)


except KeyboardInterrupt:
   log(" exiting...")

log("Close Connections")
json_file.close()
mqttc.loop_stop()
mqttc.disconnect()
ser.close()




