import time
import board
import busio
import json
import adafruit_bmp3xx
from datetime import datetime
import paho.mqtt.client as mqtt

# MQTT Setup
mqttc=mqtt.Client()
mqttc.connect("<IP or DNS-Name>",keepalive=60)
mqttc.loop_start()
lastMsg = 0

#Json
data = {}

# I2C setup
i2c = busio.I2C(board.SCL, board.SDA)
bmp = adafruit_bmp3xx.BMP3XX_I2C(i2c)

# SPI setup
# from digitalio import DigitalInOut, Direction
# spi = busio.SPI(board.SCK, board.MOSI, board.MISO)
# cs = DigitalInOut(board.D5)
# bmp = adafruit_bmp3xx.BMP3XX_SPI(spi, cs)

with open("/home/pi/weather-owm.json", "r") as json_file:
   WeatherData = json.load(json_file)
json_file.close()

bmp.sea_level_pressure = WeatherData['main']['pressure']
bmp.pressure_oversampling = 8
bmp.temperature_oversampling = 2
#bmp.sea_level_pressure = 1013.25


# MQTT 
#while True:
dt = datetime.now()
now_seconds = time.mktime(dt.timetuple()) + dt.microsecond/1e6
lastMsg = now_seconds
(result,mid) = mqttc.publish("weather/sensor/bmp388/pressure", payload=bmp.pressure, qos=2, retain=True)
(result,mid) = mqttc.publish("weather/sensor/bmp388/temperature", payload=bmp.temperature, qos=2, retain=True)
(result,mid) = mqttc.publish("weather/sensor/bmp388/altitude", payload=bmp.altitude, qos=2, retain=True)

# Save in Json-File
data['BMP388'] = []
data['BMP388'].append({
     'Pressure': bmp.pressure,
     'Temperature': bmp.temperature,
     'Altitude': bmp.altitude
})
with open('/home/pi/weather-bmp388.json', 'w') as json_file:
  json.dump(data, json_file)

json_file.close()
mqttc.disconnect()
mqttc.loop_stop()

