/*
  SDL_Weather_80422.cpp - Library for SwitchDoc Labs WeatherRack.
  SparkFun Weather Station Meters
  Argent Data Systems
  Created by SwitchDoc Labs July 27, 2014.
  Released into the public domain.
  Version 1.1 - updated constants to suppport 3.3V
  
  Supports WeatherPiArduino Board www.switchdoc.com
*/
#include <Time.h>

#include "SDL_Weather_80422.h"
#include "PinChangeInt.h"
//#include <SoftwareSerial.h>

#define pinLED     13  // LED connected to digital pin 13
//#define pinAnem    18  // Anenometer connected to pin 18 - Int 5 - Mega   / Uno pin 2
#define pinAnem    2  // Anenometer connected to pin 2 - Int 0 -  Uno pin 2
#define pinRain    3   // Rain connected to pin 3 - Int 1 - Uno Pin 3 
#define intAnem    digitalPinToInterrupt(2)   // int 0 (check for Uno)
#define intRain    digitalPinToInterrupt(3)   // int 1

#define isRainPin PD4 // int PinChange for Rainsensor 

// Notice that values that get modified inside an interrupt, that I wish to access
// outside the interrupt, are marked "volatile". It tells the compiler not to optimize
// the variable.
volatile uint16_t interruptCount=0; // The count will go back to 0 after hitting 65535.

// for mega, have to use Port B - only Port B works.
/*
 Arduino Pins         PORT
 ------------         ----
 Digital 0-7          D
 Digital 8-13         B
 Analog  0-5          C
*/

uint8_t request = 0x20; // Space
float answer = 0.0;

// initialize SDL_Weather_80422 library
SDL_Weather_80422 weatherStation(pinAnem, pinRain, intAnem, intRain, A0, SDL_MODE_INTERNAL_AD);

//SoftwareSerial mySerial(5, 6); // RX, TX

uint8_t i;

float currentWindSpeed;
float currentWindGust;
float currentWindDirection;
float totalRain;
uint8_t isRain = 0;
int State, Sum;
// Integrationszeit in Sekunden
#define LIMIT 60
unsigned long lastSeconds=0, thisSeconds;
int intervall=1; // Intervalldauer in Sekunden für isRain-Status-Ermittlung

// Do not use any Serial.print() in interrupt subroutines. Serial.print() uses interrupts,
// and by default interrupts are off in interrupt subroutines. Interrupt routines should also
// be as fast as possible. Here we just increment a counter.
void interruptFunctionRainSensor() {
    isRain++;
}

unsigned long SecondsRunning()
// Liefert die Sekunden seit Programmstart zurück
// Diese Funktion muss in der loop laufend aufgerufen werden
{ // Sekundenzähler
  static unsigned long secondsCounted=0;
  static unsigned long prevMillis=0;
  while( millis() - prevMillis >= 1000){     
    secondsCounted++;
    prevMillis += 1000;  
  }
  return secondsCounted;
}

void setup()
{ 
    Serial.begin(9600);  
  
//    Serial.println("-----------");
//    Serial.println("WeatherArduino SDL_Weather_80422 Class Test");
    Serial.println("Version 1.2 (13.10.2019) - mit UART - Kommunikation");
//    Serial.println("-----------");

    pinMode(13,OUTPUT); // LED
 
//   set the data rate for the SoftwareSerial port to Raspberry Pi
//    mySerial.begin(9600);

//    pinMode(isRainPin, INPUT_PULLUP);  // Configure the pin as an input, and turn on the pullup resistor.
                                       // See http://arduino.cc/en/Tutorial/DigitalPins
    PCintPort::attachInterrupt(isRainPin, interruptFunctionRainSensor, FALLING);
      
    weatherStation.setWindMode(SDL_MODE_SAMPLE, 5.0);
      //weatherStation.setWindMode(SDL_MODE_DELAY, 5.0);
    totalRain = 0.0;
}


void loop()
{
//  Serial.println("----------------");

  currentWindSpeed = weatherStation.current_wind_speed();
  {currentWindGust = (currentWindSpeed > currentWindGust)? currentWindSpeed : currentWindGust; }
  currentWindDirection = weatherStation.current_wind_direction();
//  totalRain = totalRain + weatherStation.get_current_rain_total()/25.4;
  totalRain = totalRain + weatherStation.get_current_rain_total();  // Korrektur beseitigen in wind_rain.py Zeile 175

  thisSeconds=SecondsRunning();
  if (thisSeconds>=lastSeconds+intervall)
  {
    lastSeconds+=intervall;
  
//  isRain?
    State = digitalRead(isRainPin);

//  Serial.print("RainPinState :");
//  Serial.println(State);
 
    if (State == 1)
        { Sum = (Sum > LIMIT)? Sum + 1 : LIMIT; }
    else
        { Sum = (Sum > 0)? Sum - 1 : 0; }
    isRain = (Sum > 0);

//    Serial.print("Sum :");
//    Serial.println(Sum);

//    Serial.print("State :");
//    Serial.println(State);

//    Serial.print("isRain? :");
//    Serial.println(isRain);

  } // Ende isRain-Status-Ermittlung 
   
//  Serial.print("rain_total=");
//  Serial.print(totalRain);
//  Serial.print(""" wind_speed=");
//  Serial.print(currentWindSpeed);
//  Serial.print(" km/h wind_gust=");
//  Serial.print(currentWindGust);
//  Serial.print(" km/h wind_direction=");
//  Serial.println(currentWindDirection);

//  Serial.print("Pin was interrupted: ");
//  Serial.print(isRain, DEC);      // print the interrupt count.
//  Serial.println(" times so far.");


  if (Serial.available()) {
    request = Serial.read();
//    Serial.print("Daten erhalten: ");
//    Serial.println(request);
    digitalWrite(13,! digitalRead(13));
    switch (request) {
        case '0':    // 0x30 "0" - Reset Rain-Total
           weatherStation.reset_rain_total();
           totalRain = 0;
           answer = totalRain;
//           Serial.println("Reset totalRain");
        break;    
        case '1':    // 0x31 "1" - Get Wind-Gust
           answer = currentWindGust;
           currentWindGust = 0;
        break;
        case '2':    // 0x32 "2" - Get Current Wind Speed
           answer = currentWindSpeed;
//           Serial.println("currentWindSpeed");
        break;
        case '3':    // 0x33 "3" - Get Current Wind Direction
           answer = currentWindDirection;
//           Serial.println("currentWindDirection");
        break;
        case '4':    // 0x34 "4" - Get Rain-Total
           answer = totalRain;
//           Serial.println("totalRain");
        break;
        case '5':    // 0x35 "5" - Get Rain
           answer = isRain;
 //          Serial.println("isRain");
        break;
        default:
           answer = 0;
//           Serial.println("Falsche Eingabe");
        break;
    }
//    Serial.print("Sende Daten: ");
//    Serial.println(answer);
    
    serialFloatPrint(answer);
  } 
  //delay(500);
 
}


void serialFloatPrint(float f) {
  byte * b = (byte *) &f;
  Serial.print("f:");
  for(int i=0; i<4; i++) {
    
    byte b1 = (b[i] >> 4) & 0x0f;
    byte b2 = (b[i] & 0x0f);
    
    char c1 = (b1 < 10) ? ('0' + b1) : 'A' + b1 - 10;
    char c2 = (b2 < 10) ? ('0' + b2) : 'A' + b2 - 10;
    
    Serial.print(c1);
    Serial.print(c2);
  }  
  //*/
  Serial.print("\n"); // um ser.readline() EOL anzugeben
//  Serial.flush();
}

